 aR w * m^9      h	 oP      nSystem-wide$NOLIST

        NAME  MiniGRiDInit

$INCLUDE (WinCnsts~Inc~)

CGROUP GROUP CODE
DGROUP GROUP DATA

EXTRN   drawWindow: WORD, firstWindow: WORD, displayWindow: WORD
EXTRN   currOrientation: BYTE, lastCursorWindow: WORD, workCursorWindow: WORD

EXTRN   InitResourceVariables: NEAR, InitEventVariables: NEAR
EXTRN   InitWindowVariables: NEAR
EXTRN   DosAlloc: NEAR, DosFree: NEAR
EXTRN   RscOpenResourceFile: NEAR, RscCloseResourceFile: NEAR
EXTRN   RscGetResource: NEAR, RscGetResourceCopy: NEAR
EXTRN   WinResetClip: NEAR, FntSetFont: NEAR, CsrSetCursor: NEAR
EXTRN   WinCreateOffscreenWindow: NEAR, CsrTurnCursorOn: NEAR

EXTRN   GfxScreenInfo: FAR, GfxSetScreenOrientation: FAR, GfxSetScreenMode: FAR

PUBLIC  pMyProgName, scrJmpTableSeg
PUBLIC  MniInitialize, MniTerminate

; EQUATES

fnCallInt         EQU 21H
initOrientation   EQU north

scrDriverRscID    EQU -1
builtInFontRscID  EQU -100
cursorsFontRscID  EQU -101
$EJECT

DATA SEGMENT PUBLIC 'DATA'
DATA ENDS


CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP, DS:DGROUP

savedVideoState DB ?
scrJmpTableSeg  DW ?
pMyProgName     DD ?

resourceLength  EQU  WORD PTR [BP-2]
resourceFileID  EQU  WORD PTR [BP-4]
builtInFontSeg  EQU  WORD PTR [BP-6]
builtInFontOff  EQU  WORD PTR [BP-8]
systemCursorSeg EQU  WORD PTR [BP-10]
systemCursorOff EQU  WORD PTR [BP-12]

MniInitialize PROC NEAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	SUB	SP, 12

	CALL	InitEventVariables
	CALL	InitResourceVariables
	CALL	InitWindowVariables

OpenSystemResourceFile:
	PUSH	AX	; Make room on stack for error variable
	MOV	SI, SP
	LES	AX, pMyProgName
	PUSH	ES
	PUSH	AX	; @Resource file name
	PUSH	SS
	PUSH	SI	; @error
	CALL	RscOpenResourceFile
	MOV	resourceFileID, AX	; Save resource file ID for closing
	POP	CX	; Error returned from RscOpenResourceFile
	JCXZ	ReadInScrDriverResource
	JMP	SHORT MniInitializeErrorHop

ReadInScrDriverResource:
	PUSH	AX	; Make room on stack for error variable
	MOV	SI, SP
	MOV	AX, scrDriverRscID
	PUSH	AX	; resource ID
	LEA	AX, resourceLength
	PUSH	SS
	PUSH	AX	; @resource length
	PUSH	SS
	PUSH	SI	; @error
	CALL	RscGetResourceCopy
	MOV	CS:scrJmpTableSeg, ES
	POP	CX	; Error returned from RscGetResourceCopy
	JCXZ	ReadInBuiltInFontResource
	JMP	SHORT MniInitializeErrorHop

ReadInBuiltInFontResource:
	PUSH	AX	; Make room on stack for error variable
	MOV	SI, SP
	MOV	AX, builtInFontRscID
	PUSH	AX	; resource ID
	LEA	AX, resourceLength
	PUSH	SS
	PUSH	AX	; @resource length
	PUSH	SS
	PUSH	SI	; @error
	CALL	RscGetResourceCopy
	MOV	builtInFontSeg, ES
	MOV	builtInFontOff, BX
	POP	CX	; Error returned from RscGetResourceCopy
	JCXZ	ReadInCursorsFontResource
	JMP	SHORT MniInitializeErrorHop

ReadInCursorsFontResource:
	PUSH	AX	; Make room on stack for error variable
	MOV	SI, SP
	MOV	AX, cursorsFontRscID
	PUSH	AX	; resource ID
	LEA	AX, resourceLength
	PUSH	SS
	PUSH	AX	; @resource length
	PUSH	SS
	PUSH	SI	; @error
	CALL	RscGetResourceCopy
	MOV	systemCursorSeg, ES
	MOV	systemCursorOff, BX
	POP	CX	; Error returned from RscGetResourceCopy
	JCXZ	CloseSystemResourceFile
	JMP	SHORT MniInitializeErrorHop

CloseSystemResourceFile:
	PUSH	AX	; Make room on stack for error variable
	MOV	SI, SP
	PUSH	resourceFileID	; resource file ID
	PUSH	SS
	PUSH	SI	; @error
	CALL	RscCloseResourceFile
	POP	CX	; Error returned from RscCloseRscFile
	JCXZ	SetInitialOrientation

MniInitializeErrorHop:
	JMP	MniInitializeError

SetInitialOrientation:
	MOV	AL, initOrientation	; Initially set screen orientation north
	MOV	CS:currOrientation, AL
	PUSH	AX
	CALL	GfxSetScreenOrientation	; Tell screen driver about orientation

	MOV	BX, SIZE WindowInfoType
	ADD	BX, 15
	SHR	BX, 1
	SHR	BX, 1
	SHR	BX, 1
	SHR	BX, 1	; Number of blocks to allocate
	CALL	DosAlloc	; Interface call to Int21, fnc 48h
	JNC	InitializeDisplayWindow

	XCHG	CX, AX
	JMP	SHORT MniInitializeErrorHop

InitializeDisplayWindow:
	MOV	DS, AX
	MOV	CS:drawWindow, AX
	MOV	CS:displayWindow, AX
	MOV	CS:firstWindow, AX

	MOV	ES, AX
	XOR	DI, DI
	MOV	CX, SIZE WindowInfoType
	SHR	CX, 1
	XOR	AX, AX	; Set all values to zero
	CLD
	REP	STOSW
	JNC	InitDisplayWindowGetSize

	STOSB

InitDisplayWindowGetSize:
	LEA	AX, DS:wiDisplayWidth
	PUSH	DS
	PUSH	AX
	CALL	GfxScreenInfo

; These two fields have to be reset to zero even after doing the STOSW above
; because the GfxScreenInfo call overwrites them with other data

	XOR	AX, AX
	MOV	DS:wiWindowFlags, AX	; Init window flags to display defaults
	MOV	DS:wiBoundsTopLeftX, AX	; Reset top left x to zero

	MOV	BX, DS:wiDisplayWidth
	MOV	CX, DS:wiDisplayHeight
	MOV	DS:wiBoundsExtentX,  BX
	MOV	DS:wiBoundsExtentY,  CX

; The values below were set to zero with the STOSW/STOSB above

;	MOV	DS:wiWindowFlags, AX
;	MOV	DS:wiNextWindow, AX	; window.next = end of list
;	MOV	DS:wiFrameType, AX	; window.frameType = no frame
;	MOV	WORD PTR DS:wiUserData + 0, AX
;	MOV	WORD PTR DS:wiUserData + 2, AX

	CALL	WinResetClip

	PUSH	builtInFontSeg
	PUSH	builtInFontOff
	CALL	FntSetFont	; Set current font to built in font

AllocateLastCursorBuffer:
	PUSH	AX	; Local variable for error
	MOV	SI, SP
	MOV	AX, cursorWidth
	PUSH	AX	; width of offscreen window
	MOV	AX, cursorHeight
	PUSH	AX	; height of offscreen window
	MOV	AL, genericFormat
	PUSH	AX	; format of offscreen window
	PUSH	SS
	PUSH	SI	; @error
	CALL	WinCreateOffscreenWindow
	MOV	CS:lastCursorWindow, AX
	POP	CX	; Get local variable off of stack
	JCXZ	AllocateWorkCursorBuffer
	JMP	SHORT MniInitializeError

AllocateWorkCursorBuffer:
	PUSH	AX	; Local variable for error
	MOV	SI, SP
	MOV	AX, cursorWidth
	PUSH	AX	; width of offscreen window
	MOV	AX, cursorHeight
	PUSH	AX	; height of offscreen window
	MOV	AL, genericFormat
	PUSH	AX	; format of offscreen window
	PUSH	SS
	PUSH	SI	; @error
	CALL	WinCreateOffscreenWindow
	MOV	CS:workCursorWindow, AX
	POP	CX	; Get local variable off of stack
	JCXZ	InitializeCursor
	JMP	SHORT MniInitializeError

InitializeCursor:
	PUSH	systemCursorSeg
	PUSH	systemCursorOff
	CALL	CsrSetCursor

; Save the current video state here (And restore at Exit time)

	PUSH	BP
	MOV	AH, 15	; Get current video state
	INT	10H	; Call BIOS' Video routines
	MOV	CS:savedVideoState, AL	; Save video state
	POP	BP

	CALL	GfxSetScreenMode	; Change graphics mode
	CALL	CsrTurnCursorOn	; Turn the cursor on
	XOR	CX, CX	; Return (0); no error
	JMP	SHORT MniInitializeRet

MniInitializeError:
	XCHG	AX, CX	; Return error in AX

MniInitializeRet:
	MOV	SP, BP
	POP	BP
	POP	DS
	RET
MniInitialize ENDP

PURGE resourceLength, resourceFileID
PURGE builtInFontSeg, builtInFontOff
PURGE systemCursorSeg, systemCursorOff


MniTerminate PROC NEAR
	PUSH	DS

	XOR	AX, AX
	PUSH	AX
	PUSH	AX
	CALL	FntSetFont	; curr font = FntSetFont (nullFont)
	CALL	DosFree

	XOR	AX, AX
	PUSH	AX
	PUSH	AX
	CALL	CsrSetCursor	; curr cursor = FntSetCursor (nullCursor)
	CALL	DosFree

	MOV	ES, CS:lastCursorWindow
	MOV	ES, ES:wiDisplayAddr	; offscreen buffer for lastCursorWindow
	CALL	DosFree
	MOV	ES, CS:lastCursorWindow	; address of lastCursorWindow record
	CALL	DosFree

	MOV	ES, CS:workCursorWindow
	MOV	ES, ES:wiDisplayAddr	; offscreen buffer for workCursorWindow
	CALL	DosFree
	MOV	ES, CS:workCursorWindow	; address of workCursorWindow record
	CALL	DosFree

	MOV	ES, CS:displayWindow	; address of displayWindow record
	CALL	DosFree

	MOV	ES, CS:scrJmpTableSeg	; address of screen driver code segment
	CALL	DosFree

	PUSH	BP
	MOV	AL, CS:savedVideoState	; Saved video state
	MOV	AH, 0	; Set video mode
	INT	10H	; Call BIOS' Video routines
	POP	BP

	POP	DS
	RET
MniTerminate ENDP


CODE    ENDS

        END
